 ; Ŀ
 ;   Fx - fix two polylines which won't join.                              
 ;   This involves finding the closest endpoints, moving the one on the    
 ;   second entity selected to coincide exactly with the one on the first  
 ;   entity, then joining them.                                            
 ;   Also contains Em, which shows if a polyline is constructed the way    
 ;   it looks.                                                             
 ;   Copyright 1996, 2006 by Rocket Software Ltd.                          
 ;                                                                         
 ; 

 ; Ŀ
 ;   Em - mark the ends of a polyline.                                     
 ; 
 (DEFUN C:EM (/ rad anginc enam typ num sub plist entt pa)
 ; Ŀ
 ;   Initialize grdraw marker settings.                                    
 ;   Angg should be local.                                                 
 ; 
  (setq rad (/ (getvar "viewsize") 50))
  (if (not (= (type angg) 'real))
      (setq angg 1.5))
  (setq anginc 0.47)
 ; Ŀ
 ;   Get a polyline.                                                       
 ; 
  (cond ((null (setq enam (car (entsel "\nPolyline to mark: "))))
         (prompt "\nNothing selected."))
        ((redraw enam 3))
        ((null (member (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
                       '("POLYLINE" "LWPOLYLINE")))
         (prompt "\n*That wasn't a polyline.*")
         (redraw enam 4))
        (t
         (if (polka enam)
             (prompt "\n*Closed polyline.*"))
         (cond ((= typ "LWPOLYLINE")
                (setq num 0)
                (while (setq sub (nth num entt))
                       (setq num (1+ num))
                       (if (= (car sub) 10)
                           (setq plist (cons (cdr sub) plist)))))
               ((= typ "POLYLINE")
                (while (/= "SEQEND"  (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
                       (setq pa (cdr (assoc 10 entt)))
                       (setq plist (cons pa plist)))))
         (setq num 0)
         (while (setq pa (nth num plist))
                (if (or (= num 0)
                        (= num (1- (length plist))))
                    (progn
                         (radi pa 0 (* rad 1.25) 6 angg 1)
                         (ci pa (* rad 1.25) 1))
                    (progn
                         (radi pa 0 rad 4 angg 4)
                         (ci pa rad 4)))
                (setq num (1+ num)))))
 (princ))
 ; Ŀ
 ;   C:Em end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine CI - grdraw circle maker.                                  
 ; 
 (DEFUN CI (pa radd colo / reps pa pa1 pa2 angg)
  (setq reps 32)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ci end.                                                               
 ; 

 ; Ŀ
 ;   Egret - get the two ends of a polyline, ara, or line.                 
 ;   Argument: an entity name.                                             
 ;   Returns a list:                                                       
 ;   (ename  entity_type  end1  end2  end1_ename  end2_ename) or nil.      
 ;   If entity_type is anything other than Polyline then the two end       
 ;   enames will both be the same as the initial ename.                    
 ;   Calls Wendy or Vrtarc.                                                
 ; 
 (DEFUN EGRET (enam / entt typp venama vertx11 venamb vertx12 ends arcdat)
  (if (setq entt (entget enam))
      (progn
           (setq typp (cdr (assoc 0 entt)))
           (cond ((= typp "POLYLINE")
                  (setq venama (entnext enam))
                  (setq vertx11 (cdr (assoc 10 (entget venama))))
                  (setq venamb (lastv enam))
                  (setq vertx12 (cdr (assoc 10 (entget venamb)))))
                 ((= typp "LWPOLYLINE")
                  (setq ends (wendy enam))
                  (setq vertx11 (car ends))
                  (setq vertx12 (cadr ends)))
                 ((= typp "LINE")
                  (setq vertx11 (cdr (assoc 10 (setq entt (entget enam)))))
                  (setq vertx12 (cdr (assoc 11 entt))))
                 ((= typp "ARC")
                  (setq vertx11 (car (setq arcdat (vrtarc enam))))
                  (setq vertx12 (cadr arcdat))))
           (if (null venama) (setq venama enam))
           (if (null venamb) (setq venamb enam))))
 (if (and enam typp vertx11 vertx12)
     (list enam typp vertx11 vertx12 venama venamb)))
 ; Ŀ
 ;   Subroutine Egret end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Fx.                                                        
 ;   Arguments: Enam1, the first entity to join (the base).                
 ;              Enam2, the second entity, which is added to the first      
 ;              and which is moved or adjusted to make it fit.             
 ;   Calls Egret and Joiach.                                               
 ;   Prints its own errors, Returns nothing.                               
 ; 
 (DEFUN FX (enam1 enam2 / rad anginc vertx11 venam11 venam12 vertx12 vertx21
                          typp2 venam21 venam22 vertx22 lista dista listb
                          distb listc distc listd distd mind pt1 pt2 pt2nam
                                                    entt ten elv sub gnulst)
 ; Ŀ
 ;   Initialize grdraw marker settings.                                    
 ;   Angg should be local.                                                 
 ; 
  (setq rad (/ (getvar "viewsize") 60))
  (if (not (= (type angg) 'real))
      (setq angg 1.5))
  (setq anginc 0.47)
 ; Ŀ
 ;   Call Egret to get the two endpoints and corresponding enames for      
 ;   the first entity.                                                     
 ; 
  (setq vertx11 (egret enam1))
  (setq venam11 (nth 4 vertx11))  ; first vertex ename
  (setq venam12 (nth 5 vertx11))  ; last vertex ename
  (setq vertx12 (cadddr vertx11)) ; last vertex location
  (setq vertx11 (caddr vertx11))  ; first vertex location
 ; Ŀ
 ;   And the second.                                                       
 ; 
  (setq vertx21 (egret enam2))
  (setq typp2 (cadr vertx21))     ; entity type
  (setq venam21 (nth 4 vertx21))  ; first vertex ename
  (setq venam22 (nth 5 vertx21))  ; last vertex ename
  (setq vertx22 (cadddr vertx21)) ; last vertex location
  (setq vertx21 (caddr vertx21))  ; first vertex location
 ; Ŀ
 ;   Mark the ends of each pline to give some indication if the ends       
 ;   are not where they appear to be.                                      
 ; 
  (radi vertx11 0 rad 4 angg 1)
  (ci vertx11 rad 1)
  (setq angg (+ angg anginc))
  (radi vertx12 0 rad 4 angg 1)
  (ci vertx12 rad 1)
  (setq angg (+ angg anginc))
  (radi vertx21 0 rad 4 angg 4)
  (ci vertx21 rad 4)
  (setq angg (+ angg anginc))
  (radi vertx22 0 rad 4 angg 4)
  (ci vertx22 rad 4)
  (setq angg (+ angg anginc))
 ; Ŀ
 ;   Find the closest two endpoints.                                       
 ;   Make four lists of distance and the two points in question and their  
 ;   entity names.  Then find the one with the shortest distance.          
 ; 
  (setq lista (list (setq dista (distance vertx11 vertx21))
                    vertx11 vertx21 venam11 venam21))
  (setq listb (list (setq distb (distance vertx11 vertx22))
                    vertx11 vertx22 venam11 venam22))
  (setq listc (list (setq distc (distance vertx12 vertx21))
                    vertx12 vertx21 venam12 venam21))
  (setq listd (list (setq distd (distance vertx12 vertx22))
                    vertx12 vertx22 venam12 venam22))
  (setq mind (min dista distb distc distd))
  (setq lista (cdr (assoc mind (list lista listb listc listd))))
  (setq pt1 (car lista))       ; closest point on enam1
  (setq pt2 (cadr lista))      ; closest point on enam2
  (setq pt2nam (cadddr lista)) ; vertex ename (if a polyline)
 ; Ŀ
 ;   Decide what to do.                                                    
 ;   If both enames refer to the same entity then quit.                    
 ; 
  (cond ((equal enam1 enam2)
         (write-line "\nThose were the same entity."))
 ; Ŀ
 ;   If the second entity was a line, change the end nearest to the        
 ;   other entity to exactly coincide with the nearest end of the other    
 ;   entity and then join the former to the latter.                        
 ; 
        ((= typp2 "LINE")
         (setq entt (entget enam2))
         (setq ten (assoc 10 entt))
         (setq elv (assoc 11 entt))
         (if (< (distance (cdr ten) pt1) (distance (cdr elv) pt1))
             (entmod (subst (cons 10 pt1) ten entt))
             (entmod (subst (cons 11 pt1) elv entt)))
         (entupd enam2)
 ; Ŀ
 ;   Joiach joins the second entity to the first if possible and prints    
 ;   an error if it wasn't.                                                
 ; 
         (joiach enam1 enam2))
 ; Ŀ
 ;   If the second entity was a polyline, change and add it.               
 ;   In this case we have the vertex enames saved.                         
 ; 
        ((= typp2 "POLYLINE")
         (setq entt (entget pt2nam))
         (entmod (subst (cons 10 pt1) (assoc 10 entt) entt))
         (joiach enam1 enam2))
 ; Ŀ
 ;   If the second entity was a lwpolyline then etc.                       
 ; 
        ((= typp2 "LWPOLYLINE")
         (setq entt (entget enam2))
         (setq pt2 (list (car pt2) (cadr pt2))) ; lwpolylines are apparently 2D
         (while (setq sub (car entt))
                (setq entt (cdr entt))
                (if (and (= (car sub) 10)
                         (equal (cdr sub) pt2))
                    (progn
                         (setq sub (cons 10 pt1))
                         (setq gnulst (append gnulst (list sub)))
                         (setq gnulst (append gnulst entt))
                         (setq entt ()))
                    (setq gnulst (append gnulst (list sub)))))
         (entmod gnulst)
         (joiach enam1 enam2))
 ; Ŀ
 ;   If it was and Arc then move it into place, it being impossible to     
 ;   predict what the user might like to see done.                         
 ;   It might be desirable to redraw the arc using the far end of the      
 ;   existing arc and its midpoint and the new endpoint.  This works       
 ;   in the drawing editor since acad allows a bit of slop in drawing      
 ;   arcs, specifically that the midpoint doesn't have to be midway        
 ;   between the endpoints (no idea how the actual midpoint is computed),  
 ;   but doing it oneself might be a bit more complex.                     
 ; 
        ((= typp2 "ARC")
         (command ".move" enam2 "" pt2 pt1)
         (joiach enam1 enam2))
 ; Ŀ
 ;   Something else.                                                       
 ; 
        (T
         (prompt "\nInput error.")))
 (princ))
 ; Ŀ
 ;   Subroutine Fx end.                                                    
 ; 

 ; Ŀ
 ;   Subroutine Joiach - join two entities into a pline, see if it worked. 
 ;   Arguments: Ename1, the base entity.                                   
 ;              Enam2, the entity to join to it.                           
 ;   If enam2 still has a corresponding entity then it wasn't joined.      
 ;   Prints an error message if the two weren't joined, but returns T if   
 ;   so and nil otherwise.                                                 
 ; 
 (DEFUN JOIACH (enam1 enam2 / typp1 exp)
  (setq typp1 (cdr (assoc 0 (entget enam1))))
  (if (member typp1 '("POLYLINE" "LWPOLYLINE"))
      (command "pedit" enam1 "j" enam2 "" "")
      (command "pedit" enam1 "y" "j" enam2 "" ""))
  (if (setq exp (entget enam2))
      (prompt "\n*Operation unsuccessful - no new polyline segments added.*"))
 (if exp t ()))
 ; Ŀ
 ;   Joiach end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Lastv - returns the ename of the last vertex of the        
 ;   polyline whose ename was passed as the sole argument.                 
 ; 
 (DEFUN LASTV (enam / goon next typp)
  (setq goon T)
  (while (and goon
              (setq typp (cdr (assoc 0 (entget (setq next (entnext enam)))))))
         (if (= typp "SEQEND")
             (setq goon ())
             (setq enam next)))
 enam)
 ; Ŀ
 ;   Lastv end.                                                            
 ; 

 ; Ŀ
 ;   Polka - see if an entity is a closed polyline or lwpolyline.          
 ;   Argument: an entity name.                                             
 ;   Returns T if a closed pline/lwpline, else nil.                        
 ; 
 (DEFUN POLKA (enam / entt typ)
  (setq entt (entget enam))
  (setq typ (cdr (assoc 0 entt)))
  (if (and (member typ '("POLYLINE" "LWPOLYLINE"))
           (= 1 (logand 1 (cdr (assoc 70 entt)))))
      t))
 ; Ŀ
 ;   Subroutine Polka end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Radi - grdraw radial line set maker.                       
 ;   Does a complete circular set.                                         
 ;   Arguments: Pa, the base point.                                        
 ;              Rin, near end distance.                                    
 ;              Rout, far end distance.                                    
 ;              Reps, number of repetions in 360 degrees.                  
 ;              Stang, the start angle.                                    
 ;              Colo, the colour.                                          
 ;   Calls its mother, returns the empties.                                
 ; 
 (DEFUN RADI (pa rin rout reps stang colo / pa1 pa2)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq pa1 (polar pa stang rin))
          (setq pa2 (polar pa stang rout))
          (grdraw pa1 pa2 colo)
          (setq stang (+ stang incr)))
 (princ))
 ; Ŀ
 ;   Radi end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Vrtarc: Find the endpoints of an arc.                      
 ;   Takes one argument, the arc ename, returns a list of the endpoints.   
 ; 
 (DEFUN VRTARC (enam / arcent cent stangl endang radd end1 end2)
  (setq arcent (entget enam))
  (setq cent (cdr (assoc 10 arcent)))
  (setq stangl (cdr (assoc 50 arcent)))
  (setq endang (cdr (assoc 51 arcent)))
  (setq radd (cdr (assoc 40 arcent)))
  (setq end1 (polar cent stangl radd))
  (setq end2 (polar cent endang radd))
 (list end1 end2))
 ; Ŀ
 ;   Vrtarc end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Wendy: Find the endpoints of an LwPolyline.                
 ;   Takes one argument, the ename, returns a list of the endpoints.       
 ; 
 (DEFUN WENDY (enam / entt eleva num sub tenlst end1 end2)
  (if (/= (type last) 'SUBR)
      (*error* "Unable to run: Last subroutine has been redefined."))
  (setq entt (entget enam))
  (if (null (setq eleva (cdr (assoc 38 entt))))
      (setq eleva 0))
  (setq num 0)
  (while (setq sub (nth num entt))
         (if (= (car sub) 10)
             (setq tenlst (cons sub tenlst)))
         (setq num (1+ num)))
  (setq end1 (append (cdar tenlst) (list eleva)))
  (setq end2 (append (cdr (last tenlst)) (list eleva)))
 (list end1 end2))
 ; Ŀ
 ;   Wendy end.                                                            
 ; 

 ; Ŀ
 ;   Fx.                                                                   
 ; 
 (DEFUN C:FX (/ osmo *error* enam1 enam2)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if osmo (setvar "osmode" osmo))
   (command "undo" "end")
   (if shk (write-line shk))
   (if (= (type enam1) 'ENAME) (redraw enam1 4))
   (if (= (type enam2) 'ENAME) (redraw enam2 4))
  (princ))
 ; Ŀ
 ;   Get two entities to forcibly join.  Check for errors.                 
 ; 
  (cond ((null (setq enam1 (car (entsel "\nBase entity: "))))
         (prompt "\nNothing selected."))
        ((redraw enam1 3))
        ((null (member (cdr (assoc 0 (entget enam1)))
                      '("ARC" "LINE" "POLYLINE" "LWPOLYLINE")))
         (prompt "\n*Unusable Entity type.*")
         (redraw enam1 4))
        ((polka enam1)
         (prompt "\n*Error - that was a closed pline.*"))
        ((null (setq enam2 (car (entsel "\nEntity to join: "))))
         (prompt "\nNothing selected.")
         (redraw enam1 4))
        ((redraw enam2 3))
        ((null (member (cdr (assoc 0 (entget enam2)))
                      '("ARC" "LINE" "POLYLINE" "LWPOLYLINE")))
         (prompt "\n*Unusable Entity type.*")
         (redraw enam2 4))
        ((polka enam2)
         (prompt "\n*Error - that was a closed pline.*")
         (redraw enam1 4))
 ; Ŀ
 ;   If nothing bad happened then call Fx to join them.                    
 ; 
        (t (fx enam1 enam2)))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))